/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
/*
 * Copyright (c) 2016, Linaro Ltd.
 */

#ifndef _UAPI_RPMSG_H_
#define _UAPI_RPMSG_H_

#include <linux/ioctl.h>
#include <linux/types.h>

/**
 * struct rpmsg_endpoint_info - endpoint info representation
 * @name: name of service
 * @src: local address
 * @dst: destination address
 */
struct rpmsg_endpoint_info {
	char name[32];
	__u32 src;
	__u32 dst;
#ifdef CONFIG_ARCH_SSTAR
	__u32 id;
#endif
};

#ifdef CONFIG_ARCH_SSTAR
#define RPMSG_CREATE_EPT_IOCTL	_IOWR(0xb5, 0x1, struct rpmsg_endpoint_info)
#else
#define RPMSG_CREATE_EPT_IOCTL	_IOW(0xb5, 0x1, struct rpmsg_endpoint_info)
#endif
#define RPMSG_DESTROY_EPT_IOCTL	_IO(0xb5, 0x2)

#endif
